﻿using System;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace CSharpBuch.Kap24
{
  class Aufgabe2
  {
    [STAThread]
    static void Main()
    {
      Application.EnableVisualStyles();
      Application.Run(new Form1());
    }
  }

  public class Form1:Form
  {
    public Form1()
    {
      this.ClientSize = new Size(200, 180);
      this.BackColor = Color.White;
      this.Text = "Grafik anzeigen";
    }

    protected override void OnPaint(PaintEventArgs e)
    {
      base.OnPaint(e);
      Graphics g = e.Graphics;
      Pen pen = new Pen(Color.Blue, 2);
      Point[] ps = { new Point(10, -90), new Point(20, -120), new Point(35, -70),  
                           new Point(45, -95), new Point(70, -50), new Point(80, -85), 
                           new Point(90,-120), new Point(95, -90), new Point(110, -120), 
                           new Point(125,-80), new Point(130, -90), new Point(145,-60)};
      g.TranslateTransform(20, 140);
      g.DrawLines(Pens.Black, ps);
      g.DrawLine(Pens.Black, new Point(-10, 0), new Point(160, 0));
      g.DrawLine(Pens.Black, new Point(0, 10), new Point(0, -130));
      for (int i = 20; i < 160; i += 20)
      {
        g.DrawLine(Pens.Black, new Point(i, 2), new Point(i, -2));
        g.DrawString("" + i, new Font("Arial", 7), Brushes.Black, new Point(i - 7, 3));
      }
      for (int i = -20; i > -130; i -= 20)
      {
        g.DrawLine(Pens.Black, new Point(-2, i), new Point(2, i));
        g.DrawString("" + i * (-1), new Font("Arial", 7), Brushes.Black, new Point(-19, i - 5));
      }
    }
  }
}